type TRecipe = 'normal' | 'wide' | 'wider' | 'ultrawide' | 'mobile';

const getCrossLinkImageUrlByType = (
    imageUrl: string,
    type: TRecipe,
): string | undefined => {
    const preparedUrl = imageUrl.endsWith('/orig')
        ? imageUrl.replace(/\/orig$/i, '/')
        : imageUrl;

    switch (type) {
        case 'mobile':
            return `${preparedUrl}offer-travel-mobile`;
        case 'wide':
            return `${preparedUrl}offer-travel-desktop-wide`;
        case 'wider':
            return `${preparedUrl}offer-travel-desktop-wider`;
        case 'normal':
            return `${preparedUrl}offer-travel-desktop`;
        case 'ultrawide':
            return `${preparedUrl}offer-travel-desktop-ultrawide`;
    }
};

export default getCrossLinkImageUrlByType;
