import {EProjectName} from 'constants/common';

import getSearchUrl from 'projects/buses/utilities/urls/getSearchUrl';
import {getRegionUrl} from 'projects/hotels/utilities/urls/getRegionUrl';
import {getTrainsSearchUrl} from 'projects/trains/lib/urls/getTrainsSearchUrl';
import {aviaURLs} from 'projects/avia/lib/urls';

const getCrossLinksUrl = ({
    type,
    fromSlug,
    toSlug,
}: {
    type: EProjectName;
    fromSlug?: string;
    toSlug: string;
}): string => {
    switch (type) {
        case EProjectName.BUSES:
            return getSearchUrl({fromSlug, toSlug});
        case EProjectName.AVIA:
            return fromSlug ? aviaURLs.getRoutePageUrl(fromSlug, toSlug) : '';
        case EProjectName.HOTELS:
            return getRegionUrl({regionSlug: toSlug});
        case EProjectName.TRAINS:
            return getTrainsSearchUrl({context: {from: fromSlug, to: toSlug}});
        default:
            return '';
    }
};

export default getCrossLinksUrl;
