import {externalUrl} from 'utilities/url/index';

export enum EPassportMode {
    AUTH,
    CHANGE_USER,
    ADD_USER,
    PROFILE,
    LOGOUT,
}

export function getPassportUrl({
    passportHost,
    mode,
    retpath,
    yu,
    uid,
}: {
    passportHost: string;
    mode: EPassportMode;
    retpath: string;
    yu?: string;
    uid?: string;
}): string {
    switch (mode) {
        case EPassportMode.AUTH: {
            return externalUrl(`${passportHost}/auth`, {
                mode: 'auth',
                retpath,
            });
        }

        case EPassportMode.CHANGE_USER: {
            return externalUrl(`${passportHost}/passport`, {
                mode: 'embeddedauth',
                action: 'change_default',
                yu,
                uid,
                retpath,
            });
        }

        case EPassportMode.ADD_USER: {
            return externalUrl(`${passportHost}/auth`, {
                mode: 'add-user',
                retpath,
            });
        }

        case EPassportMode.PROFILE: {
            return externalUrl(`${passportHost}/profile/public`, {
                retpath,
            });
        }

        case EPassportMode.LOGOUT: {
            return externalUrl(`${passportHost}/passport`, {
                mode: 'embeddedauth',
                action: 'logout',
                yu,
                uid,
                retpath,
            });
        }
    }
}
