import {EProjectName} from 'constants/common';

import {TTransportProjectName} from 'types/common/TTransportProjectName';
import {IInternalUrlOptions, IUrlQuery} from 'utilities/url/types';

import {aviaURLs} from 'projects/avia/lib/urls';
import getTrainsRouteUrl from 'projects/trains/lib/urls/getRouteUrl';
import {getBusesRouteUrl} from 'projects/buses/utilities/urls/getRouteUrl';

export function getRouteUrl({
    vertical,
    fromSlug,
    toSlug,
    query,
    options,
}: {
    vertical: TTransportProjectName;
    fromSlug: string;
    toSlug: string;
    query?: IUrlQuery;
    options?: IInternalUrlOptions;
}): string {
    switch (vertical) {
        case EProjectName.AVIA:
            return aviaURLs.getRoutePageUrl(fromSlug, toSlug, query, options);
        case EProjectName.BUSES:
            return getBusesRouteUrl(fromSlug, toSlug, query, options);
        case EProjectName.TRAINS:
            return getTrainsRouteUrl(fromSlug, toSlug, query, options);
    }
}
