import {RouteComponentProps} from 'react-router-dom';
import {stringify as qsStringify} from 'query-string';

import browserHistory from 'utilities/browserHistory/browserHistory';
import getQueryByLocation from 'utilities/getQueryByLocation/getQueryByLocation';
import {IUpdateLocationWithQueryOption} from 'utilities/updateLocationWithQuery/updateLocationWithQuery';

export default function getUrlWithUpdatedQueryByLocation(
    query: Record<string, any>,
    propLocation?: RouteComponentProps['location'],
    {useOnlyNextQuery, stringifyOptions}: IUpdateLocationWithQueryOption = {},
): string {
    const newLocation = propLocation || browserHistory?.location;

    if (!newLocation) {
        throw new Error('Нет location');
    }

    const {pathname} = newLocation;
    const queryByLocation = getQueryByLocation(newLocation);
    const updatedQuery = {
        ...queryByLocation,
        ...query,
    };

    return `${pathname}?${qsStringify(
        useOnlyNextQuery ? query : updatedQuery,
        stringifyOptions,
    )}`;
}
