import {TExpressQuery} from 'types/TExpressQuery';

import {getStringValueFromQuery} from 'utilities/url/getStringValueFromQuery';
import {WIZARD_REDIR_KEY_QUERY_NAMES} from 'utilities/url/wizard/wizardQueryNames';

export function getWizardRedirKeyFromQuery(
    query: TExpressQuery,
): string | undefined {
    return getStringValueFromQuery(query, WIZARD_REDIR_KEY_QUERY_NAMES);
}
