import * as localStorage from 'local-storage';

import {ECommonGoal} from 'utilities/metrika/types/goals/common';

import {reloadPage} from 'utilities/browser/reloadPage';
import {reachGoal} from 'utilities/metrika';
import {logDebug} from 'utilities/logger/logDebug';

const LOCALE_STORAGE_AUTH_KEY = 'travel_is_auth';

export function syncAuth(initialIsAuth: boolean): void {
    localStorage.set(LOCALE_STORAGE_AUTH_KEY, initialIsAuth);
    localStorage.on(LOCALE_STORAGE_AUTH_KEY, () => {
        reachGoal(ECommonGoal.PAGE_RELOAD_SYNC_AUTH);
        logDebug({message: 'Page reload due auth sync'});

        // ждем немного для завершения асинхронных вызовов которые не возвращают Promise
        setTimeout(reloadPage, 300);
    });
}
