import {
    TValidations,
    IFormValidationData,
} from 'types/common/validation/validation';

import rules from './rules/rules';

function getValidationError(
    value: unknown,
    formRules: TValidations | undefined,
    formData: IFormValidationData,
): string | undefined {
    if (!formRules) {
        return;
    }

    for (let i = 0; i < formRules.length; i++) {
        const rule = formRules[i];
        const isValidValue = rules[rule.type](rule.params, value, formData);

        if (!isValidValue) {
            return rule.errorMessage;
        }
    }
}

export default getValidationError;
