import moment from 'moment';

import {DateLikeType} from 'utilities/dateUtils';
import {HUMAN_DATE_RU} from 'utilities/dateUtils/formats';

/**
 * Проверяет на максимальную дату
 *
 * @param maxDateValue - значение максимальной даты, в формате dd.mm.yyyy
 * @param value - значение поля, в формате dd.mm.yyyy
 *
 * @returns true - если значение валидное
 */
export default function maxDate(
    maxDateValue: string,
    value?: DateLikeType,
): boolean {
    if (value) {
        const dateThreshold = moment(maxDateValue, HUMAN_DATE_RU);
        const dateValue = moment(value, HUMAN_DATE_RU);

        return dateValue.isSameOrBefore(dateThreshold);
    }

    return true;
}
