import moment from 'moment';

import {DateLikeType} from 'utilities/dateUtils';

/**
 * Проверяет на валидный формат даты
 *
 * @param format - формат даты, например: dd.mm.yyyy
 * @param value - значение поля
 *
 * @returns true - если значение валидное
 */
export default function validDate(
    format: string,
    value?: DateLikeType,
): boolean {
    if (value) {
        return moment(value, format, true).isValid();
    }

    return true;
}
