import {
    EValidationType,
    IFormValidationData,
} from 'types/common/validation/validation';

import required from './common/required';
import avaliable from './common/avaliable';
import regex from './string/regex';
import maxLength from './string/maxLength';
import minLength from './string/minLength';
import maxValue from './number/maxValue';
import minValue from './number/minValue';
import oneOf from './select/oneOf';
import notOneOf from './select/notOneOf';
import minDate from './date/minDate';
import maxDate from './date/maxDate';
import maxDateFromToday from './date/maxDateFromToday';
import minDateFromToday from './date/minDateFromToday';
import maxDateFromField from './date/maxDateFromField';
import minDateFromField from './date/minDateFromField';
import validDate from './date/validDate';

type TValidators = {
    [key in EValidationType]: (
        params: any,
        value: any,
        form: IFormValidationData,
    ) => boolean;
};

const rules: TValidators = {
    [EValidationType.required]: required,
    [EValidationType.available]: avaliable,

    [EValidationType.regex]: regex,
    [EValidationType.maxLength]: maxLength,
    [EValidationType.minLength]: minLength,

    [EValidationType.maxValue]: maxValue,
    [EValidationType.minValue]: minValue,

    [EValidationType.oneOf]: oneOf,
    [EValidationType.notOneOf]: notOneOf,

    [EValidationType.maxDate]: maxDate,
    [EValidationType.minDate]: minDate,
    [EValidationType.maxDateFromToday]: maxDateFromToday,
    [EValidationType.minDateFromToday]: minDateFromToday,
    [EValidationType.maxDateFromField]: maxDateFromField,
    [EValidationType.minDateFromField]: minDateFromField,
    [EValidationType.validDate]: validDate,
};

export default rules;
