import {IRegexInfo} from 'types/common/validation/validation';

/**
 * Проверяет (!не пустую) строку на соотвествие регулярному выражению.
 * Если регулярное выражение не валидное, то возвращает true.
 *
 * @param regEx - регулярка, по которой проверяется строка
 * @param value - значение поля
 *
 * @returns true - если значение валидное
 */
export default function regex(
    regEx: string | IRegexInfo,
    value?: string | null,
): boolean {
    if (!value) {
        return true;
    }

    try {
        let regexp: RegExp | undefined;

        if (typeof regEx === 'string') {
            regexp = new RegExp(regEx);
        } else if (typeof regEx === 'object') {
            regexp = new RegExp(regEx.regex, regEx.flags);
        }

        return regexp ? regexp.test(value) : true;
    } catch {
        return true;
    }
}
