import {parse} from 'query-string';
import cookies from 'js-cookie';

const YTP_REFERER_KEY = 'ytpReferer';

export function storeYtpReferer(ytpReferer: string | undefined): void {
    if (!ytpReferer) {
        return;
    }

    try {
        cookies.set(YTP_REFERER_KEY, ytpReferer, {expires: 1});
    } catch (e) {
        console.error('storeYtpReferer Error', e);
    }
}

export function restoreYtpReferer(): string | undefined {
    try {
        return cookies.get(YTP_REFERER_KEY);
    } catch (e) {
        console.error('restoreYtpReferer Error', e);

        return undefined;
    }
}

export function getYtpRefererFromQuery(
    queryString: string,
): string | undefined {
    return parse(queryString)?.['ytp_referer'] as string;
}
