/* eslint-disable valid-jsdoc */
// @ts-check
// @ts-ignore
const {addDefault} = require('@babel/helper-module-imports');

/**
 * @typedef {import('@babel/types').ImportDeclaration} ImportDeclaration
 */

/**
 * @param {import('@babel/core')} babel
 * @returns {import('@babel/core').PluginObj}
 */
module.exports = function (babel) {
    const {types: t} = babel;
    /** @type {any} */
    let classNamesImported = null;
    return {
        name: 'babel-plugin-classnames-bind',
        pre() {
            classNamesImported = null;
        },
        visitor: {
            ImportDeclaration(path) {
                if (!isStylesImport(path)) {
                    return;
                }
                const defaultSpecifier = path.node.specifiers.find(spec =>
                    t.isImportDefaultSpecifier(spec),
                );
                if (!defaultSpecifier) {
                    return;
                }
                if (!classNamesImported) {
                    classNamesImported = addDefault(path, 'classnames/bind', {
                        nameHint: 'classNamesBind',
                    });
                }
                const originalName = defaultSpecifier.local.name;
                defaultSpecifier.local.name =
                    path.scope.generateUid(originalName);
                path.insertAfter(
                    // @ts-ignore
                    babel.parse(
                        `const ${originalName} = ${classNamesImported.name}.bind(${defaultSpecifier.local.name})`,
                    ),
                );
            },
        },
    };
};

/**
 * @param {import('@babel/core').NodePath<ImportDeclaration>} path
 */
function isStylesImport(path) {
    return /\.s?css$/.test(path.node.source.value);
}
