const [, , ...files] = process.argv;

const ONLY_TS_FOLDERS = [
    'server/api/',
    'server/services/',
    'integration/helpers/',
    'integration/suites/',
    'integration/tests/',
    'src/',
];

const WHITE_LIST = [/frigga\.config/];

const pwdMatch = process.env.PWD && process.env.PWD.match(/\/(.*)$/);

const ROOT_DIR = pwdMatch ? pwdMatch[1] : null;

const RELATIVE_PATH_REGEXP = new RegExp(`${ROOT_DIR}/(.*)$`);

const jsFiles: string[] = [];

/*
 * Функция проверки на прекоммит, что в папках из списка ONLY_TS_FOLDERS нет js и jsx файлов.
 *
 * Можно проигнорировать данное правило и запустить коммит без хуков в следующих случаях:
 *     - хотфикс
 *     - если переписывание на typescript сопоставимо или превышает саму задачу по трудозатратам.
 */
function forbidJs(filePath: string): void {
    const relativePathMatch = filePath.match(RELATIVE_PATH_REGEXP);
    const relativePath = relativePathMatch ? relativePathMatch[1] : null;

    if (!relativePath) {
        return;
    }

    if (
        ONLY_TS_FOLDERS.some(tsOnlyFolder =>
            relativePath.startsWith(tsOnlyFolder),
        ) &&
        !WHITE_LIST.some(whitelistItem => whitelistItem.test(relativePath))
    ) {
        jsFiles.push(relativePath);
    }
}

files.forEach(forbidJs);

if (jsFiles.length) {
    throw new Error(
        `Перепиши пожалуйста следующие модули на typescript: ${jsFiles.map(
            jsFile => `\n\t- ${jsFile}`,
        )}`,
    );
}
