/**
 * Обвязочка над markdown-toc, которая умеет принимать в аргументах
 * несколько файлов
 */

const {execSync} = require('child_process');

const [, , ...files] = process.argv;

function execMarkDownTocSync(filePath) {
    execSync(`markdown-toc -i "${filePath}"`, {stdio: 'inherit'});
}

files.forEach(execMarkDownTocSync);
