const cluster = require('cluster');
const {Registry} = require('@yandex-data-ui/sensors');
const {noop} = require('lodash');

const {APPLY_SENSORS_EVENTS, SET_SENSOR_EVENTS} = require('./constants');

const {prepareMessage} = require('./prepareMessage');
const {createSend} = require('./createSend');

const solomonRegistry = new Registry();

function init() {
    if (process.env.QLOUD_ENVIRONMENT) {
        cluster.on('message', handle);
    } else {
        process.on('message', function (data, onSended) {
            handle(process, data);
            onSended();
        });
    }
}

const handlers = {
    [SET_SENSOR_EVENTS.SOLOMON_SET_GAUGE]: setGauge,
    [SET_SENSOR_EVENTS.SOLOMON_SET_COUNTER]: setCounter,
    [SET_SENSOR_EVENTS.SOLOMON_SET_RATE]: setRate,
};

function handle(worker, data) {
    const {message} = data;

    switch (message) {
        case SET_SENSOR_EVENTS.SOLOMON_SET_GAUGE:
        case SET_SENSOR_EVENTS.SOLOMON_SET_COUNTER:
        case SET_SENSOR_EVENTS.SOLOMON_SET_RATE: {
            const handler = handlers[message];

            const {name, labels = {}, value} = data.data;

            handler(name, labels, value);
            return;
        }
        case APPLY_SENSORS_EVENTS.SOLOMON_GET_SENSORS: {
            const send = createSend(worker);

            send(
                prepareMessage(APPLY_SENSORS_EVENTS.SOLOMON_SEND_SENSORS, {
                    data: solomonRegistry.getData(),
                }),
                noop,
            );
            return;
        }
    }
}

function setGauge(name, labels, value) {
    solomonRegistry.gauge(name, labels).addValue(value);
}

function setCounter(name, labels) {
    solomonRegistry.counter(name, labels).inc();
}

function setRate(name, labels) {
    solomonRegistry.rate(name, labels).inc();
}

module.exports = {
    init,
};
