const {TIMEOUT, APPLY_SENSORS_EVENTS} = require('./constants');

const {prepareMessage} = require('./prepareMessage');
const {createSend} = require('./createSend');

const send = createSend(process);

function getData() {
    return new Promise((resolve, reject) => {
        const handle = ({message, data}) => {
            if (message === APPLY_SENSORS_EVENTS.SOLOMON_SEND_SENSORS) {
                process.removeListener('message', handle);
                resolve(data);
            }
        };

        process.on('message', handle);

        send(
            prepareMessage(APPLY_SENSORS_EVENTS.SOLOMON_GET_SENSORS),
            () => {},
        );

        setTimeout(reject, TIMEOUT);
    });
}

module.exports = {
    getData,
};
