/**
 * Загружает SourceMap-ы в Error Booster
 * https://a.yandex-team.ru/arcadia/education/english/frontend/packages/app/scripts/source_map_upload.js
 */

const fs = require('fs');
const urlJoin = require('url-join');
const errorTools = require('@yandex-vh/error-tools');

const config = require('../.config/index');

const buildStaticDir = 'build/client'; // Путь до папки со статикой
const projectName = 'travel';

const {provider, staticPath} = config.static;
const yaStat = urlJoin(provider, staticPath); // https://yastatic.net/s3/travel/static/client/{version}

const uploadJsMapFilesFromDir = (dir: string): void => {
    fs.readdirSync(dir).forEach((file: string) => {
        if (file.endsWith('.js')) {
            const sourceMapFile = `${file}.map`;

            if (fs.existsSync(`${dir}/${sourceMapFile}`)) {
                // первым параметром путь до .map файла локально, вторым путь до js файла на статике, например
                // build/static/js/2.dec49a57.chunk.js.map https://error.yandex-team.ru/static/js/2.dec49a57.chunk.js
                // третьим параметром имя проекта, например web4 или ether
                const bundleUrl = urlJoin(yaStat, file);

                errorTools
                    .uploadSourceMap(
                        `${dir}/${sourceMapFile}`, // build/client/client.0734edad.js.map
                        bundleUrl, // https://yastatic.net/s3/travel/static/client/1.0.0-397/client.0734edad.js
                        projectName,
                    )
                    .then(() => {
                        console.log(`Upload ${sourceMapFile} succeeded.`);
                        console.log(`Bundle URL: ${bundleUrl}`);
                    })
                    .catch((e: Error) => {
                        console.error(`Upload ${sourceMapFile} failed.`, e);
                        console.log(`Bundle URL: ${bundleUrl}`);
                    });
            }
        }
    });
};

uploadJsMapFilesFromDir(buildStaticDir);
