import TypografCore from 'typograf';

/**
 * Типография текста, пока это неразрывные пробелы
 */
export default class Typograf {
    private tp: typograf.Typograf;

    constructor() {
        const tp = new TypografCore({
            locale: ['ru', 'en-US'],
        });

        /**
         * Отключить все правила
         */
        tp.disableRule('*');

        /**
         * Включаем правила про неразрывные пробелы
         */
        tp.enableRule('common/nbsp/afterShortWord');
        tp.enableRule('common/nbsp/beforeShortLastNumber');
        tp.enableRule('common/nbsp/beforeShortLastWord');
        tp.enableRule('ru/nbsp/abbr');
        tp.enableRule('ru/nbsp/addr');
        tp.enableRule('ru/nbsp/afterNumberSign');
        tp.enableRule('ru/nbsp/beforeParticle');
        tp.enableRule('ru/nbsp/centuries');
        tp.enableRule('ru/nbsp/dayMonth');
        tp.enableRule('ru/nbsp/groupNumbers');
        tp.enableRule('ru/nbsp/initials');
        tp.enableRule('ru/nbsp/mln');
        tp.enableRule('ru/nbsp/ooo');
        tp.enableRule('ru/nbsp/page');
        tp.enableRule('ru/nbsp/rubleKopek');
        tp.enableRule('ru/nbsp/see');
        tp.enableRule('ru/nbsp/year');
        tp.enableRule('ru/nbsp/years');

        this.tp = tp;
    }

    execute(str: string): string {
        return this.tp.execute(str);
    }
}
