import {ELanguages, ITranslations} from '@yandex-data-ui/i18n-ts';
import {Loader, Config} from '@yandex-data-ui/i18n-sync';

import Typograf from './Typograf';

const typograf = new Typograf();

export async function readFromFiles(): Promise<ITranslations> {
    const config = Config.load();
    const loader = Loader.fromConfig(config.data);
    const project = await loader.loadCurrent();

    const languages = [ELanguages.RU];
    const keySets = project.getKeysets();

    const translations: ITranslations = {keySets: {}};

    for (const keySet of keySets) {
        const keySetName = keySet.getName();

        translations.keySets[keySetName] = {name: keySetName, keys: {}};

        const keys = keySet.getKeys();

        for (const key of keys) {
            const keyName = key.getName();

            translations.keySets[keySetName].keys[keyName] = {
                name: keyName,
                translations: {},
            };

            for (const lang of languages) {
                const keyValue = key.getTranslation(lang).getValue();
                const sourceText = Array.isArray(keyValue)
                    ? keyValue[0]
                    : keyValue;

                translations.keySets[keySetName].keys[keyName].translations[
                    lang
                ] = {
                    lang,
                    text: typograf.execute(sourceText),
                    sourceText,
                };
            }
        }
    }

    return translations;
}
