import fs from 'fs-extra';
import chalk from 'chalk';
import {Builder} from '@yandex-data-ui/i18n-ts';
import path from 'path';

import {TRAVEL_TANKER_BRANCH, TRAVEL_TANKER_PROJECT} from '../client/constants';

import {i18nPath} from '../../../webpack/utilities/getPathParams';

import {readFromFiles} from './readFromFiles';

const BUILD_FOLDER = path.join(i18nPath, 'keysets');

const TIMER_LABEL = 'Execution time';

(async function readFromFilesAndBuild(): Promise<void> {
    console.time(TIMER_LABEL);

    try {
        fs.ensureDirSync(i18nPath);

        const translations = await readFromFiles();

        const builder = new Builder({
            outFolder: BUILD_FOLDER,
            tankerLinkOptions: {
                base: 'https://tanker.yandex-team.ru',
                isNewTanker: true,
                branch: TRAVEL_TANKER_BRANCH,
                project: TRAVEL_TANKER_PROJECT,
            },
        });

        await builder.build(translations);

        console.log(chalk.green('Tanker built success'));
    } catch (e) {
        const message = e instanceof Error ? e.message : String(e);

        console.error(
            chalk.red(
                message,
                TRAVEL_TANKER_PROJECT,
                'Tanker built with errors',
            ),
        );

        throw e;
    }

    console.timeEnd(TIMER_LABEL);
})().catch(e => {
    console.error(e);

    process.exit(1);
});
