import {execSync} from 'child_process';

export function getCurrentBranch(): string {
    let branchName = '';

    try {
        branchName = execSync('git rev-parse --abbrev-ref HEAD')
            .toString('utf8')
            .trim();
    } catch (err) {
        branchName = execSync(
            'arc info | grep -o -Ee "branch: .*" | cut -d \' \' -f 2',
        )
            .toString('utf8')
            .trim();
    }

    return branchName;
}
