const path = require('path');
const TerserPlugin = require('terser-webpack-plugin');

const uglifyJsPluginSettings = require('./utilities/getUglifyJsPluginSettings');
const {
    srcPath,
    rootPath,
    i18nPath,
    clientBuildPath,
} = require('./utilities/getPathParams');

const {isProduction, isDevelopment} = require('./variables');

const assetWebpackConfig = {
    name: 'staticAssets',
    mode: isDevelopment ? 'development' : 'production',
    devtool: false,
    context: srcPath,
    target: 'browserslist',
    entry: {
        travelCookies: path.join(srcPath, 'initCookies.ts'),
    },
    output: {
        path: clientBuildPath,
        filename: '[name].js',
    },
    module: {
        rules: [
            {
                test: /\.[tj]s$/,
                exclude: /node_modules/,
                use: ['babel-loader'],
            },
        ],
    },
    optimization: {
        minimizer: isProduction
            ? [new TerserPlugin(uglifyJsPluginSettings)]
            : [],
        realContentHash: false,
    },
    resolve: {
        alias: {
            src: srcPath,
            utilities: path.join(srcPath, 'utilities'),
            constants: path.join(srcPath, 'constants'),
            i18n: path.join(i18nPath, 'keysets'),
            types: path.join(srcPath, 'types'),
            server: path.join(rootPath, 'server'),
        },
        extensions: ['.ts', '.js'],
    },
    cache: false,
};

module.exports = assetWebpackConfig;
