const webpack = require('webpack');
const _difference = require('lodash/difference');

const {developmentBuildProjects} = require('../variables');

const ALL_BUILD_PROJECTS = [
    'index',
    'avia',
    'trains',
    'hotels',
    'buses',
    'account',
    'journal',
];

module.exports = () => {
    const needBuildProjects = developmentBuildProjects.split(',');
    const replaceBuildProjects = _difference(
        ALL_BUILD_PROJECTS,
        needBuildProjects,
    );
    const projectsPathFolderPattern = 'projects/(';
    const replaceBuildProjectsPattern = replaceBuildProjects.join('|');
    const appPathFolderPattern = ')/.+?App$';
    const fullReplaceProjectPattern =
        projectsPathFolderPattern +
        replaceBuildProjectsPattern +
        appPathFolderPattern;

    return new webpack.NormalModuleReplacementPlugin(
        // eslint-disable-next-line security/detect-non-literal-regexp
        new RegExp(fullReplaceProjectPattern, 'g'),
        'components/EmptyComponent/EmptyComponent',
    );
};
