module.exports = function ({fileType, isProduction, suffix}) {
    switch (fileType) {
        case 'js': {
            return isProduction
                ? `[name].[chunkhash:8].js${suffix}`
                : '[name].js';
        }
        case 'css': {
            return isProduction
                ? `[name].[contenthash:8].css${suffix}`
                : '[name].css';
        }

        default: {
            return isProduction
                ? `[name].[chunkhash:8].${process.env.name}.js${suffix}`
                : '[name].js';
        }
    }
};
