declare module '@yandex-int/yandex-config' {
    import Tld from 'common/interfaces/Tld';
    import Lang from 'common/interfaces/Lang';
    import AlternateLanguageDomains from 'common/interfaces/lib/url/AlternateLanguageDomains';
    import IErrorCounterConfig from 'common/interfaces/IErrorCounterConfig';

    interface IApiOptions {
        protocol: string;
        timeout: number;
        rejectUnauthorized: boolean;
        hostname: string;
    }

    interface IApiConfig {
        hostname: string;
        timeout: number;

        protocol?: string;
        rejectUnauthorized?: boolean;
    }

    interface IConfig {
        useQloudLogging: boolean;
        useDeployLogging: boolean;
        static: {
            host: string;
            hostWithoutVersion: string;
        };
        api: {
            options: IApiConfig;
            purchaseOptions: IApiConfig;
            pathfinderOptions: IApiConfig;

            useFixtures?: boolean;
        };
        errorCounter: IErrorCounterConfig;
        blablacar: {
            requestOptions: IApiOptions;
        };
        uatraits: {
            browser: string;
            profiles: string;
            module: string;
        };
        startrek: {
            options: {
                protocol: string;
                host: string;
            };
            queue: string;
            queueTravel: string;
            components: number[];

            key?: string;
            keyTravel?: string;
        };
        distribution: {
            options: {
                protocol: string;
                host: string;
            };

            token?: string;
        };
        yp: {
            options: {
                protocol: string;
                host: string;
                port: number | string;
            };

            token: string;
        };
        bunker: {
            protocol: string;
            timeout: number;
            hostname: string;
        };
        pathToVersionFile: string;
        jaeger: {
            serviceName: string;
            host: string;
        };
        langdetect: {
            availableLanguages: Record<Tld, Lang[]>;
        };
        altLangDomains: AlternateLanguageDomains[]; // Список доменов с привязкой по языкам
    }

    const configBuilder: (custom?: Partial<IConfig>) => IConfig;

    export default configBuilder;
}
