import {ApiError} from 'bla/client';
import Api from './blaClientApi';

import {CacheByParamsInMap} from '../../common/lib/cache/CacheByParamsInMap';
import apiWrapper from '../../common/lib/apiWrapper';

const cacheConfig = {
    thread: {
        size: 20,
        lifetime: 15 * 60 * 1000,
    },
    threadMap: {
        size: 20,
        lifetime: 15 * 60 * 1000,
    },
    parseContext: {
        size: 50,
        lifetime: 30 * 60 * 1000,
    },
};

const cacheMethods = new Map();

function getCacheForMethod(methodName) {
    const config = cacheConfig[methodName];

    if (!config) {
        return;
    }

    let cache = cacheMethods.get(methodName);

    if (!cache) {
        cache = new CacheByParamsInMap(config);
        cacheMethods.set(methodName, cache);
    }

    return cache;
}

const api = new Api('/api/');
const realExec = api.exec.bind(api);

api.exec = (methodName, params) => {
    const cache = getCacheForMethod(methodName);

    if (!cache) {
        return realExec(methodName, params);
    }

    return Promise.resolve().then(() => {
        const fromCache = cache.get(params);

        if (typeof fromCache !== 'undefined') {
            return fromCache;
        }

        const apiRequest = realExec(methodName, params);

        cache.set(params, apiRequest);

        return apiRequest
            .then(result => {
                // записываем результат вместо промиса
                cache.set(params, result);

                return result;
            })
            .catch(error => {
                // удаляем из кеша сфэйлившиеся запросы
                cache.del(params);

                throw error;
            });
    });
};

const apiWrapped = apiWrapper(api);

export {apiWrapped as api, ApiError};
