import FontFaceObserver from 'fontfaceobserver';
import observeStore from '../lib/observeStore';
import cookies from 'cookies-js';
import getRaspDomain from '../../common/lib/url/getRaspDomain';

export const YANDEX_SANS_CLASS = 'fonts-loaded';
export const YANDEX_SANS_COOKIE = 'fonts-loaded';

export const yandexSansDownloadObserver = store => {
    let swapped = false;

    const fontSwap = condition => {
        if (condition && cookies.get(YANDEX_SANS_COOKIE) && !swapped) {
            document.documentElement.classList.add('fonts-loaded');
            swapped = true;
        }
    };

    const visibilityApi = () => {
        const base = 'Hidden';
        const prefixes = ['', 'moz', 'webkit', 'ms'];
        let prefix;
        let prop;
        let event;

        for (let i = 0; i < prefixes.length; i++) {
            prefix = prefixes[i];

            if (prefix) {
                prop = prefix + base;
            }

            if (prop in document) {
                event = `${prefix}visibilitychange`;

                return {prop, event};
            }
        }

        return {};
    };

    const timeout = 3600000; // 1 hour

    Promise.all([
        new FontFaceObserver('YS Text', {weight: 400, style: 'normal'}).load(
            null,
            timeout,
        ),
        new FontFaceObserver('YS Text', {weight: 600, style: 'normal'}).load(
            null,
            timeout,
        ),
        new FontFaceObserver('YS Text', {weight: 700, style: 'normal'}).load(
            null,
            timeout,
        ),
    ]).then(() => {
        const {prop, event} = visibilityApi();
        const onEvent = () => {
            fontSwap(true);
            document.removeEventListener(event, onEvent);
        };
        const tld = store.getState().tld;
        const expires = new Date(Date.now() + 30 * 24 * 60 * 60 * 1000); // 30 days

        // ставим куку на основной домен
        cookies.set(YANDEX_SANS_COOKIE, true, {
            domain: getRaspDomain({tld}),
            expires,
        });
        // ставим куку на qloud-ный домен
        cookies.set(YANDEX_SANS_COOKIE, true, {
            domain: `morda-front.rasp.common.yandex.${tld}`,
            expires,
        });

        /**
         * Обрабатываем случай, когда страница невидима для пользователя (или весим обработчик на такой случай)
         * В таком случае мы можем незаметно для пользователя переключить шрифты
         */
        if (prop) {
            if (document[prop]) {
                onEvent();
            } else {
                document.addEventListener(event, onEvent);
            }
        }
    });

    /**
     * Тоже благоприятный момент для смены шрифта - переход по роутингу
     */
    observeStore(store, fontSwap, 'page', 'fetching');
};
