import get from 'lodash/get';

export default function observeStore({subscribe, getState}, cb, ...path) {
    const pick = () => get(getState(), path);

    let prevState = pick();

    function listener() {
        const nextState = pick();

        if (nextState !== prevState) {
            prevState = nextState;
            cb(nextState);
        }
    }

    cb(prevState);

    return subscribe(listener);
}

// Срабатывает только на изменение стора
// Callback не вызывается при инициализации
export function observeStoreChanges({subscribe, getState}, cb, ...path) {
    const pick = () => get(getState(), path);

    let prevState = pick();

    function listener() {
        const nextState = pick();

        if (nextState !== prevState) {
            prevState = nextState;
            cb(nextState);
        }
    }

    return subscribe(listener);
}
