import {RefObject} from 'react';

export default function scrollWindow(
    to?: number | RefObject<HTMLElement>,
    duration = 300,
): void {
    if (typeof window === 'undefined') {
        return;
    }

    const {
        requestAnimationFrame,
        scrollTo,
        pageYOffset: startPosition,
    } = window;

    let targetPosition = 0;

    if (typeof to === 'number') {
        targetPosition = to;
    } else if (to && 'current' in to && to.current) {
        targetPosition = to.current.getBoundingClientRect().top + startPosition;
    }

    const diff = targetPosition - startPosition;
    let start;

    requestAnimationFrame(function step(timestamp) {
        if (!start) {
            start = timestamp;
        }

        const time = timestamp - start;
        const percent = Math.min(time / duration, 1);
        const newPosition = Math.floor(startPosition + diff * percent);

        scrollTo(0, newPosition);

        if (time < duration) {
            requestAnimationFrame(step);
        }
    });
}
