'use strict';

const storage = window.localStorage;
const STORAGE_KEY = 'searchHistory';

function toStoragePoint(point) {
    return {
        id: point.key,
        text: point.title,
    };
}

function fromStoragePoint(storagePoint) {
    return {
        key: storagePoint.id,
        title: storagePoint.text,
    };
}

export function getItems() {
    let itemsJson;

    // До сих пор есть пользователи без localStorage или со сломанным sqlite хранилищем в браузере
    try {
        itemsJson = storage.getItem(STORAGE_KEY);
    } catch (e) {
        return [];
    }

    if (itemsJson) {
        return JSON.parse(itemsJson).map(item => ({
            ...item,
            favorite: Boolean(item.favorite),
            value: {
                from: fromStoragePoint(item.value.from),
                to: fromStoragePoint(item.value.to),
            },
        }));
    }

    return [];
}

export function saveItems(items) {
    const storageItems = items.map(storageItem => ({
        ...storageItem,
        value: {
            from: toStoragePoint(storageItem.value.from),
            to: toStoragePoint(storageItem.value.to),
        },
    }));

    try {
        storage.setItem(STORAGE_KEY, JSON.stringify(storageItems));

        return true;
    } catch (e) {
        return false;
    }
}
