import Dispatch from '../../common/interfaces/actions/Dispatch';

import getQuery from '../../common/lib/url/getQuery';

import {setUrlChanges} from '../../common/actions/page';

// Устанавливает урл в браузере, без перезагрузки страницы и обработки нового урла в роутере
export default function setUrl(dispatch: Dispatch, path: string): void {
    // Такая форма данных { path: url }, необходима для правильной работы роутера page.js
    history.replaceState({path}, '', path);
    dispatch(
        setUrlChanges({
            path,
            query: getQuery(window.location.href),
        }),
    );
}
