import {getItems, saveItems} from './../lib/searchHistoryStorage';
import {
    initializeSearchHistoryItems,
    addItemToSearchHistory,
} from '../../common/lib/searchHistory/searchHistoryManager';
import observeStore from '../lib/observeStore';

import {setSearchHistory} from '../../common/actions/searchHistory';
import {requestSampleSearchContext} from '../../common/actions/sampleSearchContext';

export function initSearchHistory(store) {
    let historyItems = getItems();

    historyItems = initializeSearchHistoryItems(historyItems);

    const serverHistory = store.getState().searchForm.searchHistory;

    if (serverHistory && serverHistory.length) {
        serverHistory.reverse().forEach(item => {
            historyItems = addItemToSearchHistory(historyItems, item.value);
        });
    }

    store.dispatch(setSearchHistory(historyItems));

    if (historyItems.length === 0) {
        // Если нет истории поиска, то запрашиваем самое популярное направление
        store.dispatch(requestSampleSearchContext());
    }
}

export function setupSearchHistory(store) {
    function onSearchHistoryChanged(items) {
        saveItems(items);
    }

    observeStore(
        store,
        onSearchHistoryChanged,
        'searchFormHints',
        'searchHistory',
    );
}
