import {batch} from 'react-redux';

import {THREAD_PAGE_NAME} from '../../common/routes/thread';

import EnvironmentType from '../../common/interfaces/EnvironmentType';

import ThreadBlablacarPolling from '../../common/lib/polling/ThreadBlablacarPolling';
import logger from '../logger';
import isRidesharingEnabled from '../../common/lib/segments/ridesharing/isRidesharingEnabled';

import {setBlablacar, setBlablacarQuerying} from '../../common/actions/thread';

let pricePolling = null;

export default function setupThreadBlablacarPolling(store, api) {
    const {getState, dispatch} = store;
    const {
        page,
        environment,
        isTouch,
        thread: {
            blablacar: {querying},
        },
        flags,
    } = getState();

    const callback = (err, result) => {
        if (err) {
            logger.error(
                'client/listeners/setupThreadBlablacarPolling.js',
                err,
            );
            result = {};
        }

        const {blablacar} = result;

        batch(() => {
            dispatch(setBlablacar({blablacar, isMobile: isTouch}));
            dispatch(setBlablacarQuerying(false));
        });
    };

    if (environment.type === EnvironmentType.server) {
        throw new Error(
            'Нельзя просто так взять и использовать ' +
                'setupThreadBlablacarPolling на стороне сервера, потому что на сервере ' +
                'переменная threadBlablacarPolling одна на весь процесс',
        );
    }

    if (!isRidesharingEnabled(flags)) {
        return false;
    }

    if (
        page.current !== THREAD_PAGE_NAME &&
        page.fetching !== THREAD_PAGE_NAME
    ) {
        return false;
    }

    if (!pricePolling) {
        pricePolling = new ThreadBlablacarPolling({store, api, callback});
    }

    if (!pricePolling.isEqualContext(store) || !pricePolling.isActual()) {
        pricePolling.stop();
        pricePolling = new ThreadBlablacarPolling({store, api, callback});
    }

    if (pricePolling.start(querying)) {
        // диспатчим признак запроса блаблакара только если полинг стартанул
        dispatch(setBlablacarQuerying(true));
    }

    return pricePolling;
}
