import {batch} from 'react-redux';

import {THREAD_PAGE_NAME} from '../../common/routes/thread';

import EnvironmentType from '../../common/interfaces/EnvironmentType';

import ThreadPricePolling from '../../common/lib/polling/ThreadPricePolling';
import logger from '../logger';

import {setSegment, setPriceQuerying} from '../../common/actions/thread';

let pricePolling = null;

export default function setupThreadPricePolling(store, api) {
    const {getState, dispatch} = store;
    const {
        page,
        environment,
        thread: {priceQuerying},
    } = getState();

    const callback = (err, result) => {
        if (err) {
            logger.error('client/listeners/setupThreadPricePolling.js', err);
            result = {};
        }

        const {segment} = result;

        batch(() => {
            dispatch(setSegment(segment));
            dispatch(setPriceQuerying(false));
        });
    };

    if (environment.type === EnvironmentType.server) {
        throw new Error(
            'Нельзя просто так взять и использовать ' +
                'setupThreadPricePolling на стороне сервера, потому что на сервере ' +
                'переменная threadPricePolling одна на весь процесс',
        );
    }

    if (
        page.current !== THREAD_PAGE_NAME &&
        page.fetching !== THREAD_PAGE_NAME
    ) {
        return false;
    }

    if (!pricePolling) {
        pricePolling = new ThreadPricePolling({store, api, callback});
    }

    if (!pricePolling.isEqualContext(store) || !pricePolling.isActual()) {
        pricePolling.stop();
        pricePolling = new ThreadPricePolling({store, api, callback});
    }

    if (pricePolling.start(priceQuerying)) {
        // диспатчим признак запроса цен только если полинг стартанул
        dispatch(setPriceQuerying(true));
    }

    return pricePolling;
}
