import Environment from '../common/interfaces/Environment';
import {ERumErrorLevel} from '../common/interfaces/rum';

/* eslint no-console: 0 */
const logger = {
    info(...args) {
        if (window.ENV === Environment.development) {
            console.log(...args);
        }
    },

    error(path, err, options = {}) {
        console.error(path, err, options);

        if (window.ENV !== Environment.development) {
            const {message, tags} = options;

            if (Ya && Ya.Rum && typeof Ya.Rum.logError === 'function') {
                Ya.Rum.logError(
                    {
                        message,
                        source: path,
                        level: ERumErrorLevel.ERROR,
                        additional: tags,
                    },
                    err,
                );
            }
        }
    },

    warn(path, err, options = {}) {
        console.warn(path, err, options);

        if (window.ENV !== Environment.development) {
            const {message, tags} = options;

            if (Ya && Ya.Rum && typeof Ya.Rum.logError === 'function') {
                Ya.Rum.logError(
                    {
                        message,
                        source: path,
                        level: ERumErrorLevel.WARN,
                        additional: tags,
                    },
                    err,
                );
            }
        }
    },
};

export default logger;
