import {createAction} from 'typesafe-actions';

import ThunkAction from '../interfaces/actions/ThunkAction';
import IApiBugReportRequest from '../interfaces/api/IApiBugReportRequest';
import Req from '../interfaces/router/Req';
import BugType from '../interfaces/state/bugReporter/BugType';

export const setReportSending = createAction(
    '@bugReporter/SET_REPORT_SENDING',
)<boolean>();
export const setSendStatus = createAction(
    '@bugReporter/SET_SEND_STATUS',
)<boolean>();
export const setTitle = createAction('@bugReporter/SET_TITLE')<string>();
export const setDescription = createAction(
    '@bugReporter/SET_DESCRIPTION',
)<string>();
export const setBugType = createAction('@bugReporter/SET_BUG_TYPE')<BugType>();
export const setFormIsOpened = createAction(
    '@bugReporter/SET_FORM_IS_OPENED',
)<boolean>();

export const sendBugReport =
    (report: IApiBugReportRequest, req?: Req): ThunkAction =>
    async ({dispatch, api}) => {
        dispatch(setReportSending(true));

        try {
            const apiResult = await api.execBugReport(report, req);

            dispatch(setSendStatus(apiResult.success));
        } catch (e) {
            dispatch(setSendStatus(false));
        }
    };
