import {setAvailableCurrencies, setCurrencyRates} from './basicActions';

export default function requestCurrencyRates(baseCurrency, req) {
    return ({getState, dispatch, api}) => {
        const {language, currencies, nationalVersion} = getState();

        if (currencies.currencyRates[baseCurrency]) {
            return Promise.resolve();
        }

        return api
            .exec(
                'currencies',
                {
                    language,
                    nationalVersion,
                    baseCurrency,
                },
                req,
            )
            .then(({availableCurrencies, currencyRates}) => {
                if (baseCurrency === currencies.nationalCurrency) {
                    dispatch(setAvailableCurrencies(availableCurrencies));
                }

                dispatch(setCurrencyRates(currencyRates));
            });
    };
}
