import requestCurrencyRates from './requestCurrencyRates';

export default function requestInitialCurrencyRates(req) {
    return ({getState, dispatch}) => {
        const {currencies} = getState();
        const {nationalCurrency, preferredCurrency} = currencies;

        const requestActions = [
            dispatch(requestCurrencyRates(nationalCurrency, req)),
        ];

        if (preferredCurrency !== nationalCurrency) {
            requestActions.push(
                dispatch(requestCurrencyRates(preferredCurrency, req)),
            );
        }

        return Promise.all(requestActions);
    };
}
