import {setPreferredCurrency} from './basicActions';
import requestCurrencyRates from './requestCurrencyRates';
import {reachGoal} from '../../lib/yaMetrika';

export default function setUserPreferredCurrency(currency, callback) {
    return ({dispatch, getState, cookies}) => {
        dispatch(setPreferredCurrency(currency));
        cookies.set('preferredcurrency', currency);

        if (typeof callback === 'function') {
            callback({dispatch, getState});
        }

        reachGoal('currency_change');

        return dispatch(requestCurrencyRates(currency));
    };
}
