import {createAction} from 'redux-actions';

import {RENDER_LIMIT} from '../lib/environment';

import EnvironmentType from '../interfaces/EnvironmentType';
import RenderMode from '../interfaces/RenderMode';

import Environment from '../interfaces/Environment';

function createClientEnvironmentOptions() {
    return {
        type: EnvironmentType.client,
        renderMode: RenderMode.full,
        segmentsLimitRender: RENDER_LIMIT,
    };
}

function createServerEnvironmentOptions({environment, isSearchBot}) {
    return {
        production: environment === Environment.production,
        type: EnvironmentType.server,
        renderMode: isSearchBot ? RenderMode.full : RenderMode.light,
        segmentsLimitRender: RENDER_LIMIT,
    };
}

export const SET_CLIENT_ENVIRONMENT = Symbol('SET_CLIENT_ENVIRONMENT');
export const setClientEnvironment = createAction(
    SET_CLIENT_ENVIRONMENT,
    createClientEnvironmentOptions,
);

export const SET_SERVER_ENVIRONMENT = Symbol('SET_SERVER_ENVIRONMENT');
export const setServerEnvironment = createAction(
    SET_SERVER_ENVIRONMENT,
    createServerEnvironmentOptions,
);
