import {createAction} from 'redux-actions';

import ThunkAction from '../interfaces/actions/ThunkAction';

export const SET_SAMPLE_SEARCH_CONTEXT = Symbol('SET_SAMPLE_SEARCH_CONTEXT');

const setSampleSearchContext = createAction(SET_SAMPLE_SEARCH_CONTEXT);

export const requestSampleSearchContext =
    (): ThunkAction =>
    ({dispatch, getState, api}) => {
        const {clientSettlement, language} = getState();

        return api
            .execSampleSearchContext({
                settlementId: clientSettlement.id,
                language,
            })
            .then(sampleSearchContext => {
                dispatch(setSampleSearchContext(sampleSearchContext));
            });
    };
