import DateSpecialValue from '../../interfaces/date/DateSpecialValue';

import isRidesharingAvailableForRequest from '../../lib/segments/ridesharing/isRidesharingAvailableForRequest';

const DEFAULT_DATA = {
    blablacar: {
        querying: false,
        tariffs: null,
    },
};

export function getBlablacarData(api, params, req) {
    const {
        context: {searchForPastDate, from, to, when},
        flags,
    } = params;

    const bbkIsAvailableForRequest = isRidesharingAvailableForRequest({
        searchForPastDate,
        from,
        to,
        flags,
    });

    if (bbkIsAvailableForRequest) {
        const blablacarParams = {
            pointFrom: from.key,
            pointTo: to.key,
            nationalVersion: params.nationalVersion,
            ...(when.special === DateSpecialValue.allDays
                ? null
                : {date: when.date}),
            poll: params.poll,
            isMobile: params.isMobile,
            flags,
        };

        return api.exec('blablacar3', blablacarParams, req);
    }

    return DEFAULT_DATA;
}
