import {LASTOCHKA} from '../../routes/searchWithSlugs';
import {LASTOCHKA_FILTER_TYPE} from '../../lib/filters/lastochka';

import {reachGoal} from '../../lib/yaMetrika';
import {
    getFilteringQuery,
    resetFiltersToDefault,
    getFilteringBySegments,
    setFilterValue as getFilteringWithNewFilterValue,
    updateFilteringByUrlQuery,
} from '../../lib/filters/filtering';

import setSearchUrl from './setSearchUrl';
import {setFiltering, resetFilters, setFilterValue} from './index';

export const updateFilterValue =
    ({type, value}) =>
    ({dispatch, getState}) => {
        dispatch(setFilterValue({type, value}));
        reachGoal(`filter_${type}_click`);
        setSearchUrl({dispatch, getState});
    };

export const updateFiltering =
    filtering =>
    ({dispatch, getState}) => {
        dispatch(setFiltering(filtering));
        setSearchUrl({dispatch, getState});
    };

function getFilteringFromQuery(query, getState) {
    const {context, segments, isSuburbanSearchResult} = getState().search;
    const filtering = getFilteringBySegments({
        context,
        segments,
        isSuburbanSearchResult,
    });

    return updateFilteringByUrlQuery({filtering, query, segments});
}

export function getFilteringFromRequest(query, params, getState) {
    const {segments} = getState().search;
    const {name} = params;
    const isLastochkaPage = name === LASTOCHKA;
    let filtering = getFilteringFromQuery(query, getState);

    if (isLastochkaPage) {
        filtering = getFilteringWithNewFilterValue({
            filtering,
            filterType: LASTOCHKA_FILTER_TYPE,
            value: true,
            segments,
        });
    }

    return filtering;
}

export const setFilteringFromRequest =
    (query, params = {}) =>
    ({dispatch, getState}) => {
        dispatch(
            setFiltering(getFilteringFromRequest(query, params, getState)),
        );
    };

export const updateFilters =
    () =>
    ({dispatch, getState}) => {
        const filteringQuery = getFilteringQuery(getState().search.filtering);

        dispatch(
            setFiltering(
                getFilteringFromQuery(
                    {
                        ...getState().page.location.query,
                        ...filteringQuery,
                    },
                    getState,
                ),
            ),
        );
    };

export const resetFiltersValues =
    () =>
    ({dispatch, getState}) => {
        const {filtering = {}, segments} = getState().search;

        dispatch(resetFilters(resetFiltersToDefault(filtering, segments)));

        setSearchUrl({dispatch, getState});
    };
