import patchSegments from '../../../lib/segments/patchSegments';
import updateSegments from '../../../lib/segments/updateSegments';
import addTariffsToSegments from '../../../lib/segments/addTariffsToSegments';
import metaCreator from './metaCreator';
import analyseSegments from '../../../lib/segments/analyseSegments';
import shouldRequestTrainTariffs from '../../../lib/search/shouldRequestTrainTariffs';
import updateTransfers from '../../../lib/segments/updateTransfers';

export function setSegmentsPayloadCreator(payload, state) {
    return analyseSegments(
        patchSegments({
            segments: payload,
            meta: metaCreator(payload, state),
        }),
        state,
    );
}

export function upsertTransfersPayloadCreator(payload, state) {
    const {segments = []} = state.search;
    const meta = metaCreator(payload, state);

    return analyseSegments(updateTransfers(segments, payload, meta), state);
}

export function updatePricesPayloadCreator(payload, state) {
    const meta = metaCreator(payload, state);
    const baseSegments = state.search.segments || [];

    return analyseSegments(
        updateSegments(baseSegments, payload.segments, meta),
        state,
    );
}

/**
 * Для статических и электричных цен.
 *
 * @param {Object[]} payload
 * @param {Object} state
 * @return {{segments: Array, transportTypes: *[], isSuburbanSearchResult: boolean}}
 */
export function setTariffsPayloadCreator(payload, state) {
    const meta = metaCreator(payload, state);
    const baseSegments = state.search.segments || [];

    return analyseSegments(
        addTariffsToSegments(baseSegments, payload, meta),
        state,
    );
}

export function setQueryingPayloadCreator(payload, {search, flags}) {
    const {pricesAreCached, context} = search;

    return pricesAreCached
        ? {
              plane: payload.plane,
              bus: payload.bus,
              train: shouldRequestTrainTariffs(context, flags) && payload.train,
          }
        : payload;
}
