import {IJoinedTransfersAnswersStatus} from '../../../lib/search/joinTransferAnswers';
import ISearchQuerying from '../../../interfaces/state/search/ISearchQuerying';
import TransferQueryStatus from '../../../interfaces/transfer/TransferQueryStatus';

export default function setTransferQueryingPayloadCreator(
    transferQueryingStatus: IJoinedTransfersAnswersStatus,
): ISearchQuerying {
    return Object.keys(transferQueryingStatus).reduce(
        (result, transportType) => {
            const name = `transfer${transportType
                .slice(0, 1)
                .toUpperCase()}${transportType.slice(1)}`;

            result[name] =
                transferQueryingStatus[transportType] ===
                TransferQueryStatus.querying;

            return result;
        },
        {},
    );
}
