import {createAction} from 'redux-actions';

import metaCreator from './helpers/metaCreator';
import {
    setTariffsPayloadCreator,
    setQueryingPayloadCreator,
    setSegmentsPayloadCreator,
    updatePricesPayloadCreator,
    upsertTransfersPayloadCreator,
} from './helpers/payloadCreators';
import setTransferQueryingPayloadCreator from './helpers/setTransferQueryingPayloadCreator';

// Search

export const SET_SEGMENTS = Symbol('SET_SEGMENTS');
export const setSegments = createAction(
    SET_SEGMENTS,
    setSegmentsPayloadCreator,
);

export const SET_EMPTY_SEARCH_RESULT = Symbol('SET_EMPTY_SEARCH_RESULT');
export const setEmptySearchResult = createAction(SET_EMPTY_SEARCH_RESULT);

export const SET_SEARCH_CONTEXT = Symbol('SET_SEARCH_CONTEXT');
export const setSearchContext = createAction(SET_SEARCH_CONTEXT);

export const UPSERT_TRANSFER_SEGMENTS = Symbol('UPSERT_TRANSFER_SEGMENTS');
export const upsertTransferSegments = createAction(
    UPSERT_TRANSFER_SEGMENTS,
    upsertTransfersPayloadCreator,
);

export const SET_TEASERS = Symbol('SET_TEASERS');
export const setTeasers = createAction(SET_TEASERS);

export const SET_PLANS = Symbol('SET_PLANS');
export const setPlans = createAction(SET_PLANS);

export const SET_TRAIN_PARTNERS = Symbol('SET_TRAIN_PARTNERS');
export const setTrainPartners = createAction(SET_TRAIN_PARTNERS);

export const SET_SEGMENT_IS_OPENED = Symbol('SET_SEGMENT_IS_OPENED');
export const setSegmentIsOpened = createAction(SET_SEGMENT_IS_OPENED);

export const SET_SEGMENT_CODESHARES_IS_OPENED = Symbol(
    'SET_SEGMENT_CODESHARES_IS_OPENED',
);
export const setSegmentCodesharesIsOpened = createAction(
    SET_SEGMENT_CODESHARES_IS_OPENED,
);

export const SET_SEO_META_INFO = Symbol('SET_SEO_META_INFO');
export const setSeoMetaInfo = createAction(SET_SEO_META_INFO);

export const SET_IS_LASTOCHKA_PAGE = Symbol('SET_IS_LASTOCHKA_PAGE');
export const setIsLastochkaPage = createAction(SET_IS_LASTOCHKA_PAGE);

export const SET_ARCHIVAL_DATA = Symbol('SET_ARCHIVAL_DATA');
export const setArchivalData = createAction(SET_ARCHIVAL_DATA);

export const SET_CANONICALS = Symbol('SET_CANONICALS');
export const setCanonicals = createAction(SET_CANONICALS);

export const SET_SEARCH_POPULAR_DIRECTIONS_LINKS = Symbol(
    'SET_SEARCH_POPULAR_DIRECTIONS_LINKS',
);
export const setSearchPopularDirectionsLinks = createAction(
    SET_SEARCH_POPULAR_DIRECTIONS_LINKS,
);

export const SET_BANNER_INFO = Symbol('SET_BANNER_INFO');
export const setBannerInfo = createAction(SET_BANNER_INFO);

// Prices

export const UPDATE_PRICES = Symbol('UPDATE_PRICES');
export const updatePrices = createAction(
    UPDATE_PRICES,
    updatePricesPayloadCreator,
    metaCreator,
);

export const SET_PRICES_ARE_CACHED = Symbol('SET_PRICES_ARE_CACHED');
export const setPricesAreCached = createAction(SET_PRICES_ARE_CACHED);

export const SET_QUERYING = Symbol('SET_QUERYING');
export const setQuerying = createAction(
    SET_QUERYING,
    setQueryingPayloadCreator,
    metaCreator,
);

export const SET_TRANSFER_QUERYING = Symbol('SET_TRANSFER_QUERYING');
export const setTransferQuerying = createAction(
    SET_TRANSFER_QUERYING,
    setTransferQueryingPayloadCreator,
);

export const SET_STATIC_TARIFFS = Symbol('SET_STATIC_TARIFFS');
export const setStaticTariffs = createAction(
    SET_STATIC_TARIFFS,
    setTariffsPayloadCreator,
    metaCreator,
);

export const SET_DYNAMIC_TARIFFS = Symbol('SET_DYNAMIC_TARIFFS');
export const setDynamicTariffs = createAction(
    SET_DYNAMIC_TARIFFS,
    updatePricesPayloadCreator,
);

export const SET_PLANE_QUERIES = Symbol('SET_PLANE_QUERIES');
export const setPlaneQueries = createAction(SET_PLANE_QUERIES);

export const SET_NEED_INITIAL_REQUEST_FOR_TRAIN_TARIFFS = Symbol(
    'SET_NEED_INITIAL_REQUEST_FOR_TRAIN_TARIFFS',
);
export const setNeedInitialRequestForTrainTariffs = createAction(
    SET_NEED_INITIAL_REQUEST_FOR_TRAIN_TARIFFS,
);

// Badges

export const SET_BADGES = Symbol('SET_BADGES');
export const setBadges = createAction(SET_BADGES);

// Blablacar

export const SET_BLABLACAR = Symbol('SET_BLABLACAR');
export const setBlablacar = createAction(SET_BLABLACAR);

// Filters

export const SET_FILTER_VALUE = Symbol('SET_FILTER_VALUE');
export const setFilterValue = createAction(SET_FILTER_VALUE);

export const SET_FILTERING = Symbol('SET_FILTERING');
export const setFiltering = createAction(SET_FILTERING);

export const RESET_FILTERS = Symbol('RESET_FILTERS');
export const resetFilters = createAction(RESET_FILTERS);

// Sorting

export const SET_SORTING = Symbol('SET_SORTING');
export const setSorting = createAction(SET_SORTING, undefined, metaCreator);
