import Dispatch from '../../interfaces/actions/Dispatch';
import GetState from '../../interfaces/actions/GetState';

import searchUrl from '../../lib/url/searchUrl';
import setUrl from '../../../client/lib/setUrl';

interface ISetSearchUrl {
    dispatch: Dispatch;
    getState: GetState;
}

/*
 * Функция сохранения состояния поиска в текущем browserHistory
 * вызывается при изменении различных фильтров, сортировок
 */
export default function setSearchUrl({
    dispatch,
    getState,
}: ISetSearchUrl): void {
    const state = getState();
    const {currencies, tld, language} = state;
    const {context, sort, filtering} = state.search;

    const url = searchUrl(
        {
            context,
            sort,
            filtering,
            currencies,
        },
        tld,
        language,
    );

    setUrl(dispatch, url);
}
