import {parseSorting} from '../../lib/sort/parse';

import setSearchUrl from './setSearchUrl';
import {setSorting} from './index';

export const updateSorting =
    ({by, reverse}) =>
    ({dispatch, getState}) => {
        dispatch(setSorting({by, reverse}, getState()));
        setSearchUrl({dispatch, getState});
    };

export const setSortingFromRequest =
    query =>
    ({dispatch, getState}) => {
        const sorting = parseSorting(query.sortBy);

        dispatch(setSorting(sorting, getState()));
    };
